const IntArrayTag = Java.loadClass('net.minecraft.nbt.IntArrayTag');
const Integer = Java.loadClass('java.lang.Integer');

const headId = new IntArrayTag([
    Integer.parseInt('1899389436'),
    Integer.parseInt('-1158069098'),
    Integer.parseInt('-1995975863'),
    Integer.parseInt('1619851654')
]);

ServerEvents.recipes(event => {
    // Shaman
    event.recipes.summoningrituals
    .altar('lote:mushroom_brew')
    .input('minecraft:sugar')
    .input('minecraft:redstone')
    .input('minecraft:glass_bottle')
    .input('minecraft:spider_eye')
    .input('minecraft:gunpowder')
    .mobOutput(
        SummoningOutput.mob('adventurez:shaman')
            .count(1)
            .offset(0, 5, 0)
            .spread(4, 0, 4)
    )
    .mobOutput(SummoningOutput.mob('drowned')
            .count(3)
            .offset(0, 5, 0)
            .spread(4, 0, 4)
    )
    .recipeTime(200)
    .id('lote:shaman')


    // Pharaoh
    event.recipes.summoningrituals
        .altar('endrem:cursed_eye')
        .itemOutput('endrem:cursed_eye')
        .input('3x rotten_flesh')
        .input('gold_block')
        .input('golden_sword')
        .mobOutput(
            SummoningOutput.mob('husk')
                .offset(0, 3, 0)
                .spread(4, 0, 4)
                .data({
                    Health: 120,
                    HandItems: [
                        {
                            id: 'golden_sword',
                            Count: 1,
                            tag: {
                                Unbreakable: 1,
                                Damage: 0,
                                Enchantments: [
                                    {
                                        id: 'sharpness',
                                        lvl: 1
                                    },
                                    {
                                        id: 'sweeping',
                                        lvl: 3
                                    },
                                    {
                                        id: 'vanishing_curse',
                                        lvl: 1
                                    }
                                ]
                            }
                        },
                        {
                            id: 'shield',
                            Count: 1,
                            tag: {
                                Damage: 0,
                                BlockEntityTag: {
                                    Patterns: [
                                        {
                                            Pattern: 'bt',
                                            Color: 11
                                        },
                                        {
                                            Pattern: 'cbo',
                                            Color: 11
                                        },
                                        {
                                            Pattern: 'mc',
                                            Color: 11
                                        },
                                        {
                                            Pattern: 'tt',
                                            Color: 11
                                        },
                                        {
                                            Pattern: 'flo',
                                            Color: 4
                                        }
                                    ],
                                    Base: 4
                                },
                                Enchantments: [
                                    {
                                        id: 'unbreaking',
                                        lvl: 1
                                    }
                                ]
                            }
                        }
                    ],
                    ArmorItems: [
                        {
                            id: 'minecraft:golden_boots',
                            Count: 1,
                            tag: {
                                Damage: 0
                            }
                        },
                        {
                            id: 'minecraft:leather_leggings',
                            Count: 1,
                            tag: {
                                Damage: 0,
                                display: {
                                    color: 1114367
                                }
                            }
                        },
                        {
                            id: 'minecraft:golden_chestplate',
                            Count: 1,
                            tag: {
                                Damage: 0
                            }
                        },
                        {
                            id: 'player_head',
                            Count: 1,
                            tag: {
                                SkullOwner: {
                                    Id: headId,
                                    Properties: {
                                        textures: [
                                            {
                                                Value: 'eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTAyNDkwMGIzZDU0ZDEzMDkxOTRkMmMyZjRjNjJhOTVmMTI3ZGY1OWI4MmM2NDE1NDdlNmU4ZmVlNTk3ZTZjIn19fQ=='
                                            }
                                        ]
                                    }
                                }
                            }
                        }
                    ],
                    Attributes: [
                        {
                            Name: 'forge:entity_gravity',
                            Base: 0.08
                        },
                        {
                            Name: 'generic.max_health',
                            Base: 120
                        },
                        {
                            Name: 'generic.movement_speed',
                            Base: 0.35
                        },
                        {
                            Name: 'generic.attack_damage',
                            Base: 6
                        },
                        {
                            Name: 'generic.armor',
                            Base: 8
                        },
                        {
                            Name: 'generic.armor_toughness',
                            Base: 6
                        }
                    ],
                    KubeJSPersistentData: {
                        bufftrigger: 100
                    },
                    Tags: ['pharaoh'],
                    CustomName: '"Pharaoh"'
                })
        )
        .mobOutput('husk')
        .mobOutput('husk')
        .mobOutput('husk')
        .recipeTime(200);

    // Elder Guardians
    event.recipes.summoningrituals
        .altar('prismarine_shard')
        .sacrifice('guardian', 3)
        .sacrificeRegion(25, 25)
        .mobOutput(
          SummoningOutput.mob('elder_guardian')
              .count(1)
              .offset(34, 7, 0)
              .spread(4, 0, 4)
        )
        .mobOutput(
          SummoningOutput.mob('elder_guardian')
              .count(1)
              .offset(-34, 7, 0)
              .spread(4, 0, 4)
        )
        .mobOutput(
          SummoningOutput.mob('elder_guardian')
              .count(1)
              .offset(0, 30, 0)
              .spread(4, 0, 4)
        )
        .recipeTime(200)
        .id('lote:elder_guardian')

    // Necromancer and Soulreaper
    event.recipes.summoningrituals
        .altar('minecraft:bone')
        .input('endrem:undead_soul')
        .input('advancednetherite:netherite_diamond_ingot')
        .input('consistency_plus:withered_bone')
        .input('spirit:soul_steel_block')
        .input('minecraft:wither_skeleton_skull')
        .mobOutput(
            SummoningOutput.mob('adventurez:necromancer')
            .data({ Health: 150, Attributes: [{ Name: 'generic.max_health', Base: 150 }] }))
        .mobOutput(
            SummoningOutput.mob('adventurez:soul_reaper')
                .count(2)
                .offset(0, 1, 0)
                .spread(4, 0, 4)
                .data({ Health: 50, Attributes: [{ Name: 'generic.max_health', Base: 50 }] })
        )
        .mobOutput(
            SummoningOutput.mob('adventurez:summoner')
                .count(1)
                .offset(0, 1, 0)
                .spread(4, 0, 4)
                .data({ Health: 50, Attributes: [{ Name: 'generic.max_health', Base: 50 }] })
        )
        .recipeTime(200)
        .blockBelow('minecraft:respawn_anchor')
        .id('lote:necromancer_soulreaper')
});